#region AuthorHeader
//
//	Shrink System version 2.0, by Xanthos
//
//
#endregion AuthorHeader
using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;
using Server.Regions;
using Xanthos.Interfaces;

namespace Xanthos.ShrinkSystem
{
	public class ShrinkCommands
	{
		private static bool m_LockDown; // TODO: need to persist this.

		public static void Initialize()
		{
			CommandHandlers.Register( "Shrink", AccessLevel.GameMaster, new CommandEventHandler( Shrink_OnCommand ) );
			CommandHandlers.Register( "ShrinkLockDown", AccessLevel.Administrator, new CommandEventHandler( ShrinkLockDown_OnCommand ) );
			CommandHandlers.Register( "ShrinkRelease", AccessLevel.Administrator, new CommandEventHandler( ShrinkRelease_OnCommand ) );
		}

		public static bool LockDown
		{
			get { return m_LockDown; }
		}

		[Usage( "Shrink" )]
		[Description( "Shrinks a creature." )]
		private static void Shrink_OnCommand( CommandEventArgs e )
		{
			PlayerMobile from = e.Mobile as PlayerMobile;

			if ( null != from )
				from.Target = new ShrinkTarget( from, null, true );
		}

		[Usage( "ShrinkLockDown" )]
		[Description( "Disables all shrinkitems in the world." )]
		private static void ShrinkLockDown_OnCommand( CommandEventArgs e )
		{
			PlayerMobile from = e.Mobile as PlayerMobile;

			if ( null != from )
				SetLockDown( from, true );
		}

		[Usage( "ShrinkRelease" )]
		[Description( "Re-enables all disabled shrink items in the world." )]
		private static void ShrinkRelease_OnCommand( CommandEventArgs e )
		{
			PlayerMobile from = e.Mobile as PlayerMobile;

			if ( null != from )
				SetLockDown( from, false );
		}

		static private void SetLockDown( Mobile from, bool lockDown )
		{
			if ( m_LockDown = lockDown )
			{
				World.Broadcast( 0x35, true, "A server wide shrinkitem lockout has initiated." );
				World.Broadcast( 0x35, true, "All shrunken pets have will remain shruken until further notice." );
			}
			else
			{
				World.Broadcast( 0x35, true, "The server wide shrinkitem lockout has been lifted." );
				World.Broadcast( 0x35, true, "You may once again unshrink shrunken pets." );
			}
		}
	}

	public class ShrinkTarget : Target
	{
		private IShrinkTool m_ShrinkTool;
		private bool m_StaffCommand;

		public ShrinkTarget( Mobile from, IShrinkTool shrinkTool, bool staffCommand ) : base( 10, false, TargetFlags.None )
		{
			m_ShrinkTool = shrinkTool;
			m_StaffCommand = staffCommand;
			from.SendMessage( "Ktere zvire chces zmensit?" );
		}

		public static bool IsOverloaded( Mobile m )
		{
			if ( !m.Player || !m.Alive || m.AccessLevel > AccessLevel.Player )
				return false;

			return ( (Mobile.BodyWeight + m.TotalWeight) > (Server.Misc.WeightOverloading.GetMaxWeight( m ) + (Server.Misc.WeightOverloading.OverloadAllowance - (int) ShrinkConfig.ShrunkenWeight)) );
		}
      
      protected override void OnTarget( Mobile from, object target )
		{
			BaseCreature pet = target as BaseCreature;

			if ( target == from )
				from.SendMessage( "Nemuzes zmensit sam/a sebe!" );

			else if ( target is Item )
			{
				if ( target is PetLeash && m_ShrinkTool is PetLeash && target != m_ShrinkTool )
				{
      			if ( ((Item)target).RootParent != from ) // Make sure its in their pack
      				from.SendLocalizedMessage( 1060640 ); // That must be in your pack for you to use it.
      			else
      			{
                  m_ShrinkTool.ShrinkCharges += ((PetLeash)target).ShrinkCharges;
                  ((Item)target).Delete();
                  from.SendMessage( "Skombinovano!" );
               }
            }
            else
               from.SendMessage( "Toto nemuzes zmensit!" );
         }

			else if ( target is PlayerMobile )
				from.SendMessage( "Tato osoba se na tebe zle podivala!" );

			else if ( Server.Spells.SpellHelper.CheckCombat( from ) )
				from.SendMessage( "Nemuzes zmensovat v boji." );

			else if ( null == pet )
				from.SendMessage( "Toto neni zvire!" );

			else if ( pet.IsDeadPet )
				from.SendMessage( "Nemuzes zmensovat mrtve!" );

			else if ( pet.Summoned || pet is BaseHire || pet is BaseTalismanSummon || pet is TalkingBaseCreature || pet is BaseEscortable )
				from.SendMessage( "Nemuzes zmensit tohoto pomocnika!" );

			else if ( !m_StaffCommand && pet.Combatant != null && pet.InRange( pet.Combatant, 12 ) && pet.Map == pet.Combatant.Map )
				from.SendMessage( "Nemuzes zmensit toto zvire kdyz bojuje." );

			else if ( pet.BodyMod != 0 )
				from.SendMessage( "Nemuzes zmensit toto zvire pokud ma zmenenou podobu." );

			else if ( !m_StaffCommand && pet.Controlled == false )
				from.SendMessage( "Nemuzes zmensit divoke zvire." );

			else if ( !m_StaffCommand && pet.ControlMaster != from )
				from.SendMessage( "Toto neni tebou ovladane zvire." );

			else if ( !m_StaffCommand && ShrinkItem.IsPackAnimal( pet ) && ( null != pet.Backpack && pet.Backpack.Items.Count > 0 ) )
				from.SendMessage( "Nemuzes zmensit zvire pokud ma v batohu nejake predmety." );
				
			else if ( IsOverloaded( from ) )
				from.SendLocalizedMessage( 1048147 ); // Your backpack can't hold anything else.
				
         else
			{
				if ( pet.ControlMaster != from && !pet.Controlled )
				{
					SpawnEntry se = pet.Spawner as SpawnEntry;
					if ( se != null && se.UnlinkOnTaming )
					{
						pet.Spawner.Remove( this );
						pet.Spawner = null;
					}

					pet.CurrentWayPoint = null;
					pet.ControlMaster = from;
					pet.Controlled = true;
					pet.ControlTarget = null;
					pet.ControlOrder = OrderType.Come;
					pet.Guild = null;
					pet.Delta( MobileDelta.Noto );
				}

				IEntity p1 = new Entity( Serial.Zero, new Point3D( from.X, from.Y, from.Z ), from.Map );
				IEntity p2 = new Entity( Serial.Zero, new Point3D( from.X, from.Y, from.Z + 50 ), from.Map );

				Effects.SendMovingParticles( p2, p1, ShrinkTable.Lookup( pet ), 1, 0, true, false, 0, 3, 1153, 1, 0, EffectLayer.Head, 0x100 );
				from.PlaySound( 492 );
				from.AddToBackpack( new ShrinkItem( pet ) );

				if ( !m_StaffCommand && null != m_ShrinkTool && m_ShrinkTool.ShrinkCharges > 0 )
				{
					if (m_ShrinkTool != typeof( HitchingPost ))
					{
                  m_ShrinkTool.ShrinkCharges--;
               }
            }
			}
		}
	}
}